<?php
/**
 * Portfolio Custom Post Type
 *
 * @package portfolio_pack
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Register the Portfolio custom post type
 */
function pp_register_portfolio_post_type() {
	register_post_type( 'portfolio', array(
	'labels' => array(
		'name' => 'Portfolios',
		'singular_name' => 'Portfolio',
		'menu_name' => 'Portfolios',
		'all_items' => 'All Portfolios',
		'edit_item' => 'Edit Portfolio',
		'view_item' => 'View Portfolio',
		'view_items' => 'View Portfolios',
		'add_new_item' => 'Add New Portfolio',
		'add_new' => 'Add New Portfolio',
		'new_item' => 'New Portfolio',
		'parent_item_colon' => 'Parent Portfolio:',
		'search_items' => 'Search Portfolios',
		'not_found' => 'No portfolios found',
		'not_found_in_trash' => 'No portfolios found in Trash',
		'archives' => 'Portfolio Archives',
		'attributes' => 'Portfolio Attributes',
		'insert_into_item' => 'Insert into portfolio',
		'uploaded_to_this_item' => 'Uploaded to this portfolio',
		'filter_items_list' => 'Filter portfolios list',
		'filter_by_date' => 'Filter portfolios by date',
		'items_list_navigation' => 'Portfolios list navigation',
		'items_list' => 'Portfolios list',
		'item_published' => 'Portfolio published.',
		'item_published_privately' => 'Portfolio published privately.',
		'item_reverted_to_draft' => 'Portfolio reverted to draft.',
		'item_scheduled' => 'Portfolio scheduled.',
		'item_updated' => 'Portfolio updated.',
		'item_link' => 'Portfolio Link',
		'item_link_description' => 'A link to a portfolio.',
	),
	'public' => true,
	'show_in_rest' => true,
	'menu_icon' => 'dashicons-portfolio',
	'supports' => array(
		'title',
		'thumbnail',
		'custom-fields',
	),
	'delete_with_user' => false,
) );
}
add_action('init', 'pp_register_portfolio_post_type', 10);
