<?php
/**
 * Portfolio Pack Module
 *
 * @package portfolio_pack
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


// Include post types
require_once dirname(__FILE__) . '/includes/post-types/portfolio.php';

// Include helpers
require_once dirname(__FILE__) . '/includes/helpers/acf-helpers.php';
//require_once dirname(__FILE__) . '/includes/helpers/acf-choice-sync.php';
require_once dirname(__FILE__) . '/includes/helpers/acf-add-field.php';

// Include ACF fields
require_once dirname(__FILE__) . '/includes/acf-fields/portfolio-details-fields.php';
require_once dirname(__FILE__) . '/includes/acf-fields/portfolio-fields.php';

// Include settings page
if (function_exists('i_am_mw') && i_am_mw()) {
    require_once dirname(__FILE__) . '/includes/admin/settings-page.php';
}

// Load enabled modules
function pp_load_modules() {
    // Get available modules
    $modules_dir = dirname(__FILE__) . '/includes/modules';

    // Check if modules directory exists
    if (!is_dir($modules_dir)) {
        return;
    }

    // Get all module directories
    $module_dirs = glob($modules_dir . '/*', GLOB_ONLYDIR);

    foreach ($module_dirs as $module_dir) {
        $module_id = basename($module_dir);
        // Check if module is enabled
        if (function_exists('pp_is_module_enabled') && !pp_is_module_enabled($module_id)) {
            continue;
        }

        // Check if module init file exists
        $module_file = $module_dir . '/module.php';
        if (file_exists($module_file)) {
            include_once($module_file);
        }
    }
}
add_action('et_builder_ready', 'pp_load_modules');
