<?php
/**
 * Portfolio Pack Uninstall
 *
 * Uninstalling Portfolio Pack deletes user roles, options, tables, and other data.
 *
 * @package portfolio_pack
 */

// Exit if accessed directly.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('portfolio_pack_settings');
delete_option('portfolio_pack_version');

// Delete any transients
delete_transient('portfolio_pack_flush_rewrite_rules');

// Clear any scheduled hooks
wp_clear_scheduled_hook('portfolio_pack_daily_maintenance');

// Get all portfolio posts
$portfolio_posts = get_posts(
    array(
        'post_type'      => 'portfolio',
        'posts_per_page' => -1,
        'post_status'    => 'any',
        'fields'         => 'ids',
    )
);

// Delete all portfolio posts and their meta data
foreach ($portfolio_posts as $post_id) {
    wp_delete_post($post_id, true);
}

// Flush rewrite rules
flush_rewrite_rules();
