document.addEventListener("DOMContentLoaded", function () {
    const tooltips = document.querySelectorAll("[data-tooltip-trigger]");

    tooltips.forEach(el => {
        // Mobile tap toggle
        el.addEventListener("click", function (e) {
            if (window.matchMedia("(hover: none) and (pointer: coarse)").matches) {
                e.preventDefault();
                e.stopPropagation();
                
                // Close all other tooltips first
                tooltips.forEach(other => {
                    if (other !== el) {
                        other.classList.remove("active");
                    }
                });
                
                el.classList.toggle("active");
            }
        });

        // Handle pulse animation only once
        if (el.classList.contains("highlight-pulse")) {
            el.classList.add("pulse-once");
        }
    });

    // Close tooltips when tapping outside on mobile
    document.addEventListener("click", function (e) {
        if (window.matchMedia("(hover: none) and (pointer: coarse)").matches) {
            const isTooltipClick = e.target.closest("[data-tooltip-trigger]");
            if (!isTooltipClick) {
                tooltips.forEach(tooltip => {
                    tooltip.classList.remove("active");
                });
            }
        }
    });

    // Re-trigger pulse on scroll past 100px
    let hasTriggered = false;
    window.addEventListener("scroll", function () {
        if (window.scrollY > 100 && !hasTriggered) {
            hasTriggered = true;
            document.querySelectorAll(".highlight-pulse").forEach(el => {
                el.classList.remove("pulse-once");
                void el.offsetWidth; // reflow
                el.classList.add("pulse-once");
            });
        }
    });
});
