/**
 * Admin JavaScript for Site Tutorials Manager (stm-admin.js)
 * Handles video modal, instant filtering, and the Add/Edit form modal.
 */
jQuery(document).ready(function($) {

	var $videoModal = $('#stm-video-modal');
	var $iframe = $('#stm-video-frame');
	var $editModal = $('#stm-edit-modal');
	var $form = $('#stm-tutorial-form');
	var $searchInput = $('#stm-search-input');
	var $tutorialList = $('#stm-tutorial-list');

	// --- Video Modal Logic ---

	function closeVideoModal() {
		$videoModal.css('display', 'none');
		$iframe.attr('src', '');
	}

	$tutorialList.on('click', '.play-video', function(e) {
		e.preventDefault();
		var videoUrl = $(this).data('video-url');
		if (videoUrl) {
			$iframe.attr('src', videoUrl);
			$videoModal.css('display', 'block');
		} else {
			alert('Error: Video URL not found.');
		}
	});

	// 2. Close Modal Handlers (Applies to both video and edit modals)
	$('.stm-close').on('click', function() {
		closeVideoModal();
		$editModal.css('display', 'none');
	});

	$(window).on('click', function(e) {
		if (e.target === $videoModal[0]) {
			closeVideoModal();
		}
		if (e.target === $editModal[0]) {
			$editModal.css('display', 'none');
		}
	});
	
	$(document).on('keydown', function(e) {
		if (e.key === "Escape") {
			if ($videoModal.css('display') === 'block') {
				closeVideoModal();
			} else if ($editModal.css('display') === 'block') {
				$editModal.css('display', 'none');
			}
		}
	});

	// --- Instant Keyup Filtering Logic ---
	
	$searchInput.on('keyup', function() {
		var filterText = $(this).val().toLowerCase();
		var foundCount = 0;

		$tutorialList.find('tr').each(function() {
			var $row = $(this);
			if ($row.hasClass('no-items')) return true; 

			var title = $row.data('title') ? $row.data('title').toLowerCase() : '';
			var description = $row.data('description') ? $row.data('description').toLowerCase() : '';

			if (title.indexOf(filterText) > -1 || description.indexOf(filterText) > -1) {
				$row.show();
				foundCount++;
			} else {
				$row.hide();
			}
		});
		
		var $noItemsRow = $tutorialList.find('.no-items');
		if (foundCount === 0) {
			if ($noItemsRow.length === 0) {
				if ($tutorialList.children('tr').length > 0) {
					$tutorialList.append('<tr><td colspan="3" class="no-items">No tutorials found matching your filter.</td></tr>');
				}
			} else {
				$noItemsRow.show();
			}
		} else {
			$noItemsRow.hide();
		}
	}).trigger('keyup');

	// --- Add/Edit Form Modal Logic (Admin Mode) ---

	// 4. Open modal for ADD
	$('#stm-add-tutorial').on('click', function() {
		$('#stm-form-title').text('Add New Tutorial');
		
		$form[0].reset(); 
		$('#tutorial_id').val(''); 
		
		$editModal.css('display', 'block');
	});

	// 5. Open modal for EDIT
	$tutorialList.on('click', '.stm-edit-tutorial', function() {
		var $row = $(this).closest('tr');
		
		// --- THIS SECTION IS UPDATED TO PULL THE ORIGINAL URL ---
		var id = $row.data('video-id');
		var title = $row.data('title');
		var description = $row.data('description');
		// Fetch the stored original URL from the data attribute
		var originalUrl = $row.data('original-url'); 
		
		$('#stm-form-title').text('Edit Tutorial: ' + title);
		
		// Populate the form fields
		$('#tutorial_id').val(id);
		$('#title').val(title);
		$('#description').val(description);
		$('#video_url').val(originalUrl); // Set the URL field correctly

		$editModal.css('display', 'block');
	});

});