<?php
/**
 * Merge Tags for Framework Demo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', function() {
	$registry = Slipstream_Registry::get_instance();

	$registry->register( 'merge_tags', 'demo_welcome', array(
		'description' => 'The welcome message from Demo Settings.',
		'data_source' => 'php:ss_demo_get_welcome_message',
		'group'       => 'custom',
		'priority'    => 10,
	) );
} );

function ss_demo_get_welcome_message() {
	$settings = get_option( 'ss_demo_settings', array() );
	return $settings['welcome_message'] ?? 'Default Welcome';
}
