<?php
/**
 * Custom Dashboard Widget for Framework Demo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', function() {
	// Only show when the framework-demo package is active
	$registry = Slipstream_Registry::get_instance();
	$packages = $registry->get_data( 'packages' );
	
	if ( ! isset( $packages['framework-demo'] ) || ! $packages['framework-demo']['active'] ) {
		return;
	}

	$registry->register( 'widgets', 'demo_overview', array(
		'name'     => 'Demo Overview',
		'callback' => 'ss_demo_render_overview_widget',
		'priority' => 10,
	) );
} );

function ss_demo_render_overview_widget() {
	$count = wp_count_posts( 'ss_demo_item' )->publish;
	$settings = get_option( 'ss_demo_settings', array() );
	$color = $settings['theme_color'] ?? '#3b82f6';
	?>
	<div class="space-y-4">
		<div class="flex items-center justify-between">
			<span class="text-sm text-slate-500">Total Demo Items</span>
			<span class="text-lg font-bold text-slate-900"><?php echo $count; ?></span>
		</div>
		<div class="h-2 w-full bg-slate-100 rounded-full overflow-hidden">
			<div class="h-full transition-all duration-500" style="width: <?php echo min(100, $count * 10); ?>%; background-color: <?php echo esc_attr($color); ?>;"></div>
		</div>
		<p class="text-xs text-slate-400">
			<?php echo esc_html( $settings['welcome_message'] ?? 'Welcome to the framework demo.' ); ?>
		</p>
	</div>
	<?php
}
