jQuery(document).ready(function($) {
    // Post Status Toggle AJAX
    $(document).on('change', '.ss-status-toggle-input', function() {
        const $input = $(this);
        const $wrapper = $input.closest('.ss-status-toggle-wrapper');
        const $label = $wrapper.find('.ss-status-label');
        const postId = $wrapper.data('post-id');
        const nonce = $input.data('nonce');
        const isChecked = $input.prop('checked');
        const newStatus = isChecked ? 'publish' : 'draft';

        // Visual feedback
        $input.prop('disabled', true);
        $label.css('opacity', '0.5');

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'slipstream_toggle_post_status',
                post_id: postId,
                status: newStatus,
                nonce: nonce
            },
            success: function(response) {
                if (response.success) {
                    $label.text(response.data.label);
                } else {
                    alert('Error: ' + response.data);
                    // Revert
                    $input.prop('checked', !isChecked);
                }
            },
            error: function() {
                alert('Network error occurred.');
                // Revert
                $input.prop('checked', !isChecked);
            },
            complete: function() {
                $input.prop('disabled', false);
                $label.css('opacity', '1');
            }
        });
    });
});
