jQuery(document).ready(function($) {
    // Only run on post edit/new screens
    if (!$('body').hasClass('post-php') && !$('body').hasClass('post-new-php')) {
        return;
    }

    const $publishBox = $('#submitdiv');
    if (!$publishBox.length) return;

    // Create the new top nav bar
    const $editorNav = $('<div id="ss-editor-nav"></div>');
    const postTitle = $('#title').val() || 'Untitled Post';
    
    const $titleTrigger = $('<div id="ss-editor-title-trigger"><span>' + postTitle + '</span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></div>');
    $editorNav.append($titleTrigger);

    // Create our action bar (reused from previous implementation but styled for the new nav)
    const $actionBar = $('<div id="ss-post-actions"></div>');
    
    // Status Badge Removed - integrated into Publish button

    // Save Draft
    const $saveDraft = $('#save-post');
    if ($saveDraft.length) {
        const $draftBtn = $('<button type="button" class="ss-action-btn secondary">Save Draft</button>');
        $draftBtn.on('click', function() { $saveDraft.click(); });
        $actionBar.append($draftBtn);
    }

    // Move to Trash
    const $deleteAction = $('.submitdelete');
    if ($deleteAction.length) {
        const $trashBtn = $('<button type="button" class="ss-action-btn danger">Trash</button>');
        $trashBtn.on('click', function() {
            if (confirm('Are you sure you want to move this to trash?')) {
                window.location.href = $deleteAction.attr('href');
            }
        });
        $actionBar.append($trashBtn);
    }

    // Publish / Update Button
    const $originalPublish = $('#publish');
    let $publishBtn;
    if ($originalPublish.length) {
        const label = $originalPublish.val();
        $publishBtn = $('<button type="button" class="ss-action-btn primary">' + label + '</button>');
        $publishBtn.on('click', function() { $originalPublish.click(); });
        $actionBar.append($publishBtn);

        // Sync with original button label (e.g. Schedule vs Publish vs Update)
        const btnObserver = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.type === 'attributes' && mutation.attributeName === 'value') {
                    const newLabel = $originalPublish.val();
                    if (!isDirty) {
                        $publishBtn.text(newLabel);
                    } else {
                        $publishBtn.html(newLabel + ' <span class="ss-btn-status ml-2 text-[10px] opacity-70 uppercase tracking-wider font-black">● Unsaved</span>');
                    }
                }
            });
        });
        btnObserver.observe($originalPublish[0], { attributes: true });
    }

    $editorNav.append($actionBar);

    // Inject the new nav at the top of the content area
    $('#slipstream-content').prepend($editorNav);

    // --- Title Modal Logic ---
    $titleTrigger.on('click', function() {
        const currentTitle = $('#title').val();
        const currentSlug = $('#post_name').val();
        
        const $modalContainer = $('<div id="ss-title-modal-container"></div>');
        const $modal = $('<div id="ss-title-modal"></div>');
        
        $modal.append('<h3>Edit Title & Permalink</h3>');
        $modal.append('<label>Post Title</label>');
        const $titleInput = $('<input type="text" id="ss-modal-title-input">').val(currentTitle);
        $modal.append($titleInput);
        
        $modal.append('<label>Permalink Slug</label>');
        const $slugInput = $('<input type="text" id="ss-modal-slug-input">').val(currentSlug);
        $modal.append($slugInput);
        
        const $actions = $('<div class="modal-actions"></div>');
        const $cancelBtn = $('<button type="button" class="btn-cancel">Cancel</button>');
        const $saveBtn = $('<button type="button" class="btn-save">Apply</button>');
        
        $actions.append($cancelBtn).append($saveBtn);
        $modal.append($actions);
        $modalContainer.append($modal);
        $('body').append($modalContainer);
        
        $titleInput.focus();

        $cancelBtn.on('click', function() { $modalContainer.remove(); });
        $modalContainer.on('click', function(e) { if (e.target === this) $modalContainer.remove(); });

        $saveBtn.on('click', function() {
            const newTitle = $titleInput.val();
            const newSlug = $slugInput.val();
            
            $('#title').val(newTitle).trigger('change');
            $('#post_name').val(newSlug).trigger('change');
            
            $titleTrigger.find('span').text(newTitle || 'Untitled Post');
            $modalContainer.remove();
            setDirty();
        });
    });

    // Detect changes to update status badge
    let isDirty = false;
    const setDirty = function() {
        if (!isDirty) {
            isDirty = true;
            if ($publishBtn) {
                const originalLabel = $originalPublish.val();
                $publishBtn.html(originalLabel + ' <span class="ss-btn-status ml-2 text-[10px] opacity-70 uppercase tracking-wider font-black">● Unsaved</span>');
                $publishBtn.addClass('unsaved');
            }
        }
    };

    // Listen for inputs
    $(document).on('input change', '#poststuff input, #poststuff textarea, #poststuff select', function() {
        setDirty();
    });

    // TinyMCE integration
    if (typeof tinymce !== 'undefined') {
        if (tinymce.editors.length) {
            tinymce.editors.forEach(function(ed) {
                ed.on('change input', function() { setDirty(); });
            });
        }
        tinymce.on('AddEditor', function(e) {
            e.editor.on('change input', function() { setDirty(); });
        });
    }

    // ACF integration
    if (typeof acf !== 'undefined') {
        acf.add_action('change', function($el) { setDirty(); });
    }

    // Sync button states with original publish button
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
                const $publishBtn = $actionBar.find('.ss-action-btn.primary');
                if ($originalPublish.hasClass('disabled')) {
                    $publishBtn.prop('disabled', true).css('opacity', '0.5');
                } else {
                    $publishBtn.prop('disabled', false).css('opacity', '1');
                }
            }
        });
    });

    if ($originalPublish.length) {
        observer.observe($originalPublish[0], { attributes: true });
    }
});
