<?php
/**
 * Functions for Framework Demo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'slipstream_init', function( $registry ) {
    // Register an assignable content field
    $registry->register_content_field( 'framework-demo', array(
        'name'        => 'Hero Title',
        'description' => 'The main headline for the hero banner on this page.',
        'merge_tag'   => 'hero_title',
    ) );

    $registry->register_content_field( 'framework-demo', array(
        'name'        => 'Hero Subtitle',
        'description' => 'Supporting text for the hero title.',
        'merge_tag'   => 'hero_subtitle',
    ) );

    // Register them as standard merge tags too so they show up in the scanner
    $registry->register( 'merge_tags', 'hero_title', array(
        'name'        => 'Hero Title',
        'description' => 'Page-specific hero headline.',
        'data_source' => 'Dynamic Content Field',
        'group'       => 'custom',
    ) );

    $registry->register( 'merge_tags', 'hero_subtitle', array(
        'name'        => 'Hero Subtitle',
        'description' => 'Page-specific hero subtitle.',
        'data_source' => 'Dynamic Content Field',
        'group'       => 'custom',
    ) );

    // Register a universal callback example
    $registry->register_callback( 'demo_universal_callback', array(
        'name'        => 'Universal Demo Callback',
        'callback'    => function( $id ) {
            return "Universal: " . $id;
        },
        'description' => 'Appends "Universal: " to the ID.',
    ) );

    // Register a context-specific callback example
    $registry->register_callback( 'demo_social_callback', array(
        'name'        => 'Social ID Formatter',
        'callback'    => function( $id ) {
            return "https://example.com/user/" . $id;
        },
        'description' => 'Formats ID into a full URL.',
        'context'     => array( 'social', 'team-members' ),
    ) );
} );
