<?php
/**
 * Panels Registration for Framework Demo
 * Version: 1.0.7
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', function() {
	$registry = Slipstream_Registry::get_instance();

	// 1. Register a Dashboard Panel for the Custom Post Type
	$registry->register( 'panels', 'demo_items', array(
		'name'        => 'Demo Items',
		'description' => 'Manage demo items for the boilerplate example.',
		'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" /></svg>',
		'icon_bg'     => '#3b82f6',
		'icon_color'  => '#ffffff',
		'url'         => admin_url( 'edit.php?post_type=ss_demo_item' ),
		'group'       => 'content',
		'priority'    => 50,
		'count'       => function() {
			$count = wp_count_posts( 'ss_demo_item' )->publish;
			return $count > 0 ? '<span class="dml-badge" style="background: #3b82f6;">' . $count . ' Items</span>' : 0;
		},
	) );

	// 2. Register a Dashboard Panel for Settings
	$registry->register( 'panels', 'demo_settings', array(
		'name'        => 'Demo Settings',
		'description' => 'Boilerplate settings demonstration.',
		'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>',
		'icon_bg'     => '#8b5cf6',
		'icon_color'  => '#ffffff',
		'url'         => admin_url( 'admin.php?page=ss-demo-settings' ),
		'group'       => 'settings',
		'priority'    => 50,
		'save_mapping' => array(
			'label' => 'Save Demo Settings',
			'form'  => '#ss-demo-settings-form'
		),
	) );
}, 20 );

// Register the actual settings page in WP
add_action( 'admin_menu', function() {
	add_submenu_page(
		null, // Hidden from standard menu
		'Demo Settings',
		'Demo Settings',
		'is_slipstream_owner',
		'ss-demo-settings',
		'ss_demo_render_settings_page'
	);
} );

/**
 * Register Administrator (Developer) Config
 */
add_action( 'init', function() {
	$registry = Slipstream_Registry::get_instance();
	$registry->register_admin_config( 'framework-demo', 'ss_demo_render_admin_config' );
}, 30 );

function ss_demo_render_admin_config() {
	$api_key = get_option( 'ss_demo_api_key', '' );
	$log_level = get_option( 'ss_demo_log_level', 'error' );
	?>
	<div class="ss-admin-config-fields space-y-6">
		<div>
			<h2 class="text-lg font-bold text-slate-900 mb-1"><?php _e( 'Demo Integration', 'slipstream' ); ?></h2>
			<p class="text-sm text-slate-500 mb-4"><?php _e( 'Configure developer-only settings for the framework demo.', 'slipstream' ); ?></p>
		</div>

		<div class="ss-field p-4 bg-slate-50 rounded-2xl border border-slate-100">
			<label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 ml-1"><?php _e( 'Internal API Key', 'slipstream' ); ?></label>
			<input type="password" name="ss_demo_api_key" value="<?php echo esc_attr( $api_key ); ?>" class="w-full bg-white border-slate-200 rounded-xl p-3 text-sm font-medium" placeholder="Demo-Secret-Key">
			<p class="text-[10px] text-slate-400 mt-2 ml-1"><?php _e( 'An example of a sensitive setting that only developers should see.', 'slipstream' ); ?></p>
		</div>

		<div class="pt-6 border-t border-slate-50">
			<label class="flex items-center gap-3 p-4 bg-white rounded-2xl border border-slate-100 cursor-pointer hover:border-indigo-200 transition-all">
				<input type="checkbox" name="ss_demo_enable_debug" value="1" <?php checked( get_option('ss_demo_enable_debug'), 1 ); ?> class="ss-toggle-conditional rounded text-indigo-600 focus:ring-indigo-500" data-target="demo-debug-options">
				<span class="text-sm font-bold text-slate-700"><?php _e( 'Enable Debug Mode', 'slipstream' ); ?></span>
			</label>
		</div>

		<div id="demo-debug-options" class="p-4 bg-indigo-50/50 rounded-2xl border border-indigo-100/50 space-y-4" style="display: none;">
			<div class="ss-field">
				<label class="block text-[10px] font-bold text-indigo-600 uppercase tracking-wider mb-2 ml-1"><?php _e( 'Log Level', 'slipstream' ); ?></label>
				<select name="ss_demo_log_level" class="w-full bg-white border-indigo-100 rounded-xl p-2.5 text-xs font-bold text-indigo-700 focus:ring-indigo-500 focus:border-indigo-500">
					<option value="error" <?php selected( $log_level, 'error' ); ?>><?php _e( 'Error', 'slipstream' ); ?></option>
					<option value="info" <?php selected( $log_level, 'info' ); ?>><?php _e( 'Info', 'slipstream' ); ?></option>
					<option value="debug" <?php selected( $log_level, 'debug' ); ?>><?php _e( 'Debug', 'slipstream' ); ?></option>
				</select>
			</div>
		</div>
	</div>
	<?php
}

add_action( 'slipstream_save_developer_config', function( $post_data ) {
	if ( isset( $post_data['ss_demo_api_key'] ) ) {
		update_option( 'ss_demo_api_key', sanitize_text_field( $post_data['ss_demo_api_key'] ) );
	}
	if ( isset( $post_data['ss_demo_enable_debug'] ) ) {
		update_option( 'ss_demo_enable_debug', 1 );
	} else {
		update_option( 'ss_demo_enable_debug', 0 );
	}
	if ( isset( $post_data['ss_demo_log_level'] ) ) {
		update_option( 'ss_demo_log_level', sanitize_text_field( $post_data['ss_demo_log_level'] ) );
	}
} );
