<?php
/**
 * Post Type Registration for Framework Demo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', function() {
	register_post_type( 'ss_demo_item', array(
		'labels' => array(
			'name'               => _x( 'Demo Items', 'post type general name', 'slipstream' ),
			'singular_name'      => _x( 'Demo Item', 'post type singular name', 'slipstream' ),
			'menu_name'          => _x( 'Demo Items', 'admin menu', 'slipstream' ),
			'add_new'            => _x( 'Add New', 'demo item', 'slipstream' ),
			'add_new_item'       => __( 'Add New Demo Item', 'slipstream' ),
			'edit_item'          => __( 'Edit Demo Item', 'slipstream' ),
			'new_item'           => __( 'New Demo Item', 'slipstream' ),
			'view_item'          => __( 'View Demo Item', 'slipstream' ),
			'all_items'          => __( 'All Demo Items', 'slipstream' ),
			'search_items'       => __( 'Search Demo Items', 'slipstream' ),
			'not_found'          => __( 'No demo items found.', 'slipstream' ),
			'not_found_in_trash' => __( 'No demo items found in Trash.', 'slipstream' ),
		),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => false, // We use Slipstream Dashboard instead
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'demo-item' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
		'show_in_rest'       => true,
	) );
} );

// Grant capabilities to Owner role
add_action( 'init', function() {
	$registry = Slipstream_Registry::get_instance();
	$registry->add_owner_capability_all( 'ss_demo_item' );

	// Enable status toggle for this post type
	$registry->register( 'status_toggle_post_types', 'ss_demo_item', array( 'enabled' => true ) );
}, 30 );
