<?php
/**
 * Settings UI for Framework Demo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handle settings save
 */
add_action( 'admin_init', function() {
	if ( isset( $_POST['ss_save_demo_settings'] ) ) {
		check_admin_referer( 'ss_save_demo_settings' );
		
		if ( ! current_user_can( 'is_slipstream_owner' ) && ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$settings = isset( $_POST['ss_demo'] ) ? $_POST['ss_demo'] : array();
		
		// Sanitize and save
		$sanitized = array(
			'welcome_message' => sanitize_text_field( $settings['welcome_message'] ?? '' ),
			'feature_enabled' => isset( $settings['feature_enabled'] ),
			'theme_color'     => sanitize_hex_color( $settings['theme_color'] ?? '#3b82f6' ),
		);
		
		update_option( 'ss_demo_settings', $sanitized );

		wp_safe_redirect( add_query_arg( 'settings-updated', 'true', wp_get_referer() ) );
		exit;
	}
} );

/**
 * Render the settings page
 */
function ss_demo_render_settings_page() {
	$settings = get_option( 'ss_demo_settings', array(
		'welcome_message' => 'Hello World!',
		'feature_enabled' => true,
		'theme_color'     => '#3b82f6',
	) );
	?>
	<div class="wrap">
		<div class="flex items-center justify-between mb-8">
			<h1 class="text-2xl font-bold text-slate-900">Demo Settings</h1>
		</div>

		<form method="post" id="ss-demo-settings-form">
			<input type="hidden" name="ss_save_demo_settings" value="1">
			<?php wp_nonce_field( 'ss_save_demo_settings' ); ?>
		
			<div class="bg-white rounded-3xl shadow-sm border border-slate-100 p-8 space-y-8 max-w-2xl">
				<div class="space-y-4">
					<label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">Welcome Message</label>
					<input type="text" name="ss_demo[welcome_message]" value="<?php echo esc_attr( $settings['welcome_message'] ); ?>" class="w-full bg-slate-100 border-none rounded-2xl text-sm font-bold text-slate-700 p-4" placeholder="Enter message...">
				</div>

				<div class="pt-8 border-t border-slate-100 flex items-center justify-between">
					<div>
						<h3 class="text-lg font-bold text-slate-900">Enable Demo Feature</h3>
						<p class="text-sm text-slate-500">Toggle this feature on or off.</p>
					</div>
					<label class="relative inline-flex items-center cursor-pointer">
						<input type="checkbox" name="ss_demo[feature_enabled]" value="1" class="sr-only peer" <?php checked( $settings['feature_enabled'] ); ?>>
						<div class="w-11 h-6 bg-slate-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
					</label>
				</div>

				<div class="pt-8 border-t border-slate-100">
					<label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">Theme Color</label>
					<input type="color" name="ss_demo[theme_color]" value="<?php echo esc_attr( $settings['theme_color'] ); ?>" class="w-full h-12 p-1 bg-slate-100 border-none rounded-xl">
				</div>
			</div>
		</form>
	</div>
	<?php
}
