<?php
/**
 * Activity Log Class - Tracks system changes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

final class Slipstream_Activity_Log {

	private static $instance;
	private $option_name = 'slipstream_activity_log';

	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	private function __construct() {
		// Private constructor
	}

	/**
	 * Log an event
	 */
	public function log( $action, $details = '', $status = 'success' ) {
		$logs = get_option( $this->option_name, array() );
		
		$new_entry = array(
			'timestamp' => current_time( 'mysql' ),
			'user'      => wp_get_current_user()->display_name,
			'action'    => $action,
			'details'   => $details,
			'status'    => $status,
		);

		array_unshift( $logs, $new_entry );

		// Keep only last 100 entries
		if ( count( $logs ) > 100 ) {
			$logs = array_slice( $logs, 0, 100 );
		}

		update_option( $this->option_name, $logs, false );
	}

	/**
	 * Get logs
	 */
	public function get_logs() {
		return get_option( $this->option_name, array() );
	}

	/**
	 * Clear logs
	 */
	public function clear_logs() {
		delete_option( $this->option_name );
	}
}
