<?php
/**
 * Dashboard Widgets Handler Class
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

final class Slipstream_Widgets {

	private static $instance;

	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	private function __construct() {}

	/**
	 * Get registered widgets sorted by priority
	 */
	public function get_widgets() {
		$registry = Slipstream_Registry::get_instance();
		$widgets = $registry->get_data( 'widgets' );

		if ( empty( $widgets ) ) {
			return array();
		}

		uasort( $widgets, function( $a, $b ) {
			return ( $a['priority'] ?? 10 ) - ( $b['priority'] ?? 10 );
		} );

		return $widgets;
	}

	/**
	 * Render a widget's content
	 */
	public function render_widget_content( $widget ) {
		if ( isset( $widget['content'] ) ) {
			if ( is_callable( $widget['content'] ) ) {
				return call_user_func( $widget['content'] );
			}
			return $widget['content'];
		}
		return '';
	}
}
