<?php
/**
 * Main Shell Template (Tailwind-powered)
 * This file replaces the standard WP Admin interface for the Owner role.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div id="slipstream-shell" class="min-h-screen flex flex-col bg-gray-100 font-sans antialiased text-gray-900 relative">
    <!-- Main Content Area -->
    <main id="slipstream-main" class="flex-1 max-w-7xl mx-auto w-full px-4 md:px-0">
        <?php
        $brand_name = get_option( 'slipstream_brand_name', 'Slipstream' );
        $brand_logo = get_option( 'slipstream_brand_logo' );

        $is_dashboard = false;
        if ( function_exists( 'get_current_screen' ) ) {
            $current_screen = get_current_screen();
            $is_dashboard = ( $current_screen && ( $current_screen->base === 'dashboard' || $current_screen->base === 'dashboard-network' ) );
        }

        // Fallback check for dashboard or preview
        if ( ! $is_dashboard && ( basename( $_SERVER['PHP_SELF'] ) === 'index.php' || isset( $_GET['slipstream_preview'] ) ) && ! isset( $_GET['page'] ) ) {
            $is_dashboard = true;
        }
        ?>

        <?php
        if ( $is_dashboard ) :
            $user_id = get_current_user_id();
            $is_admin = current_user_can( 'manage_options' );
            $owner_view_enabled = get_user_meta( $user_id, 'slipstream_owner_view_enabled', true ) === '1';
            ?>
            <!-- SSPanel Layout (macOS System Preferences style) -->
            <div class="flex flex-col md:flex-row gap-0 md:gap-8">

                <!-- Left Column: Settings Options (Package Panels) -->
                <div id="slipstream-sidebar" class="w-full md:w-1/3 flex flex-col h-auto bg-transparent overflow-hidden shadow-none">
                    <!-- Search Bar -->
                    <div class="slipstream-search-container">
                        <input type="text" id="slipstream-sidebar-search" class="slipstream-sidebar-search" placeholder="Search" autocomplete="off">
                        <span class="search-icon">
                            <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </span>
                    </div>

                    <div class="flex-1 overflow-y-auto custom-scrollbar pb-6 max-h-screen">
                        <div class="space-y-8 px-2 pt-0" id="slipstream-panels-list">
                            <?php
                            $registry = Slipstream_Registry::get_instance();
                            $panels = $registry->get_data( 'panels' );
                            $groups = $registry->get_groups();

                            if ( ! empty( $panels ) ) :
                                // Group panels
                                $grouped_panels = array();
                                foreach ( $panels as $slug => $panel ) {
                                    $group_slug = isset( $panel['group'] ) ? $panel['group'] : 'settings';
                                    if ( ! isset( $grouped_panels[$group_slug] ) ) {
                                        $grouped_panels[$group_slug] = array();
                                    }
                                    $panel['slug'] = $slug;
                                    $grouped_panels[$group_slug][] = $panel;
                                }

                                // Sort panels within groups
                                foreach ( $grouped_panels as $group_slug => &$group_panels ) {
                                    usort( $group_panels, function( $a, $b ) {
                                        return ( $a['priority'] ?? 10 ) - ( $b['priority'] ?? 10 );
                                    } );
                                }

                                // Iterate through groups in priority order
                                foreach ( $groups as $group_slug => $group_args ) :
                                    if ( empty( $grouped_panels[$group_slug] ) ) continue;
                                    ?>
                                    <div class="group-section" data-group-name="<?php echo esc_attr( strtolower( $group_args['name'] ) ); ?>">
                                        <h2 class="text-xs font-bold text-gray-500 uppercase tracking-widest px-1 mb-3"><?php echo esc_html( $group_args['name'] ); ?></h2>
                                        <div class="bg-white rounded-2xl shadow-sm overflow-hidden slipstream-panel-group">
                                            <?php foreach ( $grouped_panels[$group_slug] as $panel ) :
                                                // Skip panels that are explicitly hidden from the owner view
                                                if ( isset( $panel['show_in_owner'] ) && $panel['show_in_owner'] === false ) {
                                                    continue;
                                                }

                                                $icon_bg = isset( $panel['icon_bg'] ) ? $panel['icon_bg'] : '';
                                                $icon_color = isset( $panel['icon_color'] ) ? $panel['icon_color'] : '';
                                                $icon_style = '';
                                                if ( $icon_bg ) $icon_style .= 'background-color: ' . esc_attr( $icon_bg ) . ';';
                                                if ( $icon_color ) $icon_style .= 'color: ' . esc_attr( $icon_color ) . ';';
                                                ?>
                                                <?php
                                                $style = isset( $panel['style'] ) ? $panel['style'] : 'default';

                                                if ( $style === 'toggle' ) :
                                                    $toggle_status = is_callable( $panel['toggle_status'] ) ? call_user_func( $panel['toggle_status'] ) : $panel['toggle_status'];
                                                    $is_on = ( $toggle_status === true || $toggle_status === 'on' || $toggle_status === 'yes' );
                                                    ?>
                                                    <div class="panel-item panel-item-toggle flex items-center justify-between px-4 py-3 hover:bg-gray-50 transition-colors group relative"
                                                         data-panel-name="<?php echo esc_attr( strtolower( $panel['name'] ) ); ?>"
                                                         data-panel-desc="<?php echo esc_attr( strtolower( $panel['description'] ?? '' ) ); ?>"
                                                         data-panel-slug="<?php echo esc_attr( $panel['slug'] ); ?>">
                                                        <div class="flex items-center gap-3">
                                                            <div class="w-8 h-8 rounded-lg flex items-center justify-center transition-colors slipstream-panel-icon" style="<?php echo $icon_style; ?>">
                                                                <?php
                                                                if ( isset( $panel['icon'] ) ) {
                                                                    if ( strpos( $panel['icon'], '<svg' ) !== false ) {
                                                                        echo $panel['icon'];
                                                                    } else {
                                                                        echo '<span class="text-lg">' . $panel['icon'] . '</span>';
                                                                    }
                                                                } else {
                                                                    echo '<span class="text-lg">📦</span>';
                                                                }
                                                                ?>
                                                            </div>
                                                            <div class="font-medium text-gray-900 truncate text-sm"><?php echo esc_html( $panel['name'] ); ?></div>
                                                        </div>
                                                        <div class="flex items-center gap-3">
                                                            <?php if ( isset( $panel['count'] ) ) :
                                                                $count_val = is_callable( $panel['count'] ) ? call_user_func( $panel['count'] ) : $panel['count'];
                                                                if ( $count_val !== null && $count_val !== 0 && $count_val !== '0' ) : ?>
                                                                    <div class="flex items-center">
                                                                        <?php
                                                                        if ( strpos( $count_val, '<' ) !== false ) {
                                                                            echo $count_val;
                                                                        } else {
                                                                            echo '<span class="text-xs text-gray-400">' . esc_html( $count_val ) . '</span>';
                                                                        }
                                                                        ?>
                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                            <button type="button"
                                                                    class="slipstream-toggle-btn relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none <?php echo $is_on ? 'bg-indigo-600' : 'bg-gray-200'; ?>"
                                                                    data-slug="<?php echo esc_attr( $panel['slug'] ); ?>"
                                                                    data-action="<?php echo esc_attr( $panel['toggle_action'] ?? '' ); ?>"
                                                                    data-nonce="<?php echo esc_attr( wp_create_nonce( 'slipstream_toggle_' . $panel['slug'] ) ); ?>"
                                                                    role="switch"
                                                                    aria-checked="<?php echo $is_on ? 'true' : 'false'; ?>">
                                                                <span aria-hidden="true" class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out <?php echo $is_on ? 'translate-x-5' : 'translate-x-0'; ?>"></span>
                                                            </button>
                                                        </div>
                                                    </div>
                                                <?php elseif ( $style === 'hero' ) : ?>
                                                    <div class="panel-item panel-item-hero flex flex-col gap-4 px-4 py-5 hover:bg-gray-50 transition-colors group relative border-b last:border-b-0 border-gray-100"
                                                         data-panel-name="<?php echo esc_attr( strtolower( $panel['name'] ) ); ?>"
                                                         data-panel-desc="<?php echo esc_attr( strtolower( $panel['description'] ?? '' ) ); ?>"
                                                         data-panel-slug="<?php echo esc_attr( $panel['slug'] ); ?>">
                                                        <div class="flex items-center justify-between">
                                                            <a href="<?php echo esc_url( $panel['url'] ); ?>" class="flex items-center gap-4 flex-1 min-w-0">
                                                                <div class="w-14 h-14 rounded-2xl flex items-center justify-center transition-colors slipstream-panel-icon shadow-sm" style="<?php echo $icon_style; ?>">
                                                                    <?php
                                                                    if ( isset( $panel['icon'] ) ) {
                                                                        if ( strpos( $panel['icon'], '<svg' ) !== false ) {
                                                                            echo $panel['icon'];
                                                                        } else {
                                                                            echo '<span class="text-3xl">' . $panel['icon'] . '</span>';
                                                                        }
                                                                    } else {
                                                                        echo '<span class="text-3xl">👤</span>';
                                                                    }
                                                                    ?>
                                                                </div>
                                                                <div class="min-w-0">
                                                                    <div class="font-extrabold text-gray-900 text-base truncate"><?php echo esc_html( $panel['name'] ); ?></div>
                                                                    <?php if ( ! empty( $panel['description'] ) ) : ?>
                                                                        <p class="text-sm text-gray-500 truncate leading-relaxed"><?php echo esc_html( $panel['description'] ); ?></p>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </a>
                                                            <a href="<?php echo esc_url( $panel['url'] ); ?>" class="text-gray-300 group-hover:text-indigo-500 transition-colors">
                                                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                                                </svg>
                                                            </a>
                                                        </div>
                                                    </div>
                                                <?php elseif ( $style === 'subtle' ) : ?>
                                                    <?php if ( $panel['slug'] === 'logout' && $is_admin && $owner_view_enabled ) : ?>
                                                        <div class="panel-item panel-item-subtle flex items-center justify-between p-0 hover:bg-gray-50 transition-colors group relative border-b border-gray-100"
                                                             data-panel-name="exit slipstream view"
                                                             data-panel-slug="exit-owner-view">
                                                            <a href="<?php echo admin_url( 'index.php?slipstream_owner_view=0' ); ?>" class="flex items-center gap-2 flex-1 px-4 py-2">
                                                                <div class="text-rose-400 group-hover:text-rose-600 transition-colors">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 6 6 18"/><path d="m6 6 12 12"/></svg>
                                                                </div>
                                                                <div class="text-xs font-semibold text-rose-500 group-hover:text-rose-700 transition-colors uppercase tracking-wider">Exit Slipstream View</div>
                                                            </a>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="panel-item panel-item-subtle flex items-center justify-between p-0 hover:bg-gray-50 transition-colors group relative border-b last:border-b-0 border-gray-100"
                                                         data-panel-name="<?php echo esc_attr( strtolower( $panel['name'] ) ); ?>"
                                                         data-panel-desc="<?php echo esc_attr( strtolower( $panel['description'] ?? '' ) ); ?>"
                                                         data-panel-slug="<?php echo esc_attr( $panel['slug'] ); ?>">
                                                        <a href="<?php echo esc_url( $panel['url'] ); ?>" class="flex items-center gap-2 flex-1 px-4 py-2">
                                                            <?php if ( isset( $panel['icon'] ) ) : ?>
                                                                <div class="text-gray-400 group-hover:text-gray-600 transition-colors">
                                                                    <?php
                                                                    if ( strpos( $panel['icon'], '<svg' ) !== false ) {
                                                                        echo $panel['icon'];
                                                                    } else {
                                                                        echo '<span class="text-sm">' . $panel['icon'] . '</span>';
                                                                    }
                                                                    ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="text-xs font-semibold text-gray-500 group-hover:text-gray-700 transition-colors uppercase tracking-wider"><?php echo esc_html( $panel['name'] ); ?></div>
                                                        </a>
                                                    </div>
                                                <?php elseif ( $style === 'card' ) : ?>
                                                    <div class="panel-item panel-item-card flex flex-col gap-3 px-4 py-4 hover:bg-gray-50 transition-colors group relative border-b last:border-b-0 border-gray-100"
                                                         data-panel-name="<?php echo esc_attr( strtolower( $panel['name'] ) ); ?>"
                                                         data-panel-desc="<?php echo esc_attr( strtolower( $panel['description'] ?? '' ) ); ?>"
                                                         data-panel-slug="<?php echo esc_attr( $panel['slug'] ); ?>">
                                                        <div class="flex items-center justify-between">
                                                            <a href="<?php echo esc_url( $panel['url'] ); ?>" class="flex items-center gap-3 flex-1 min-w-0">
                                                                <div class="w-10 h-10 rounded-xl flex items-center justify-center transition-colors slipstream-panel-icon shadow-sm" style="<?php echo $icon_style; ?>">
                                                                    <?php
                                                                    if ( isset( $panel['icon'] ) ) {
                                                                        if ( strpos( $panel['icon'], '<svg' ) !== false ) {
                                                                            echo $panel['icon'];
                                                                        } else {
                                                                            echo '<span class="text-xl">' . $panel['icon'] . '</span>';
                                                                        }
                                                                    } else {
                                                                        echo '<span class="text-xl">📦</span>';
                                                                    }
                                                                    ?>
                                                                </div>
                                                                <div class="min-w-0">
                                                                    <div class="font-bold text-gray-900 text-sm truncate"><?php echo esc_html( $panel['name'] ); ?></div>
                                                                    <?php if ( ! empty( $panel['description'] ) ) : ?>
                                                                        <p class="text-xs text-gray-500 truncate leading-relaxed"><?php echo esc_html( $panel['description'] ); ?></p>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </a>
                                                            <div class="flex items-center gap-3">
                                                                <?php if ( isset( $panel['count'] ) ) :
                                                                    $count_val = is_callable( $panel['count'] ) ? call_user_func( $panel['count'] ) : $panel['count'];
                                                                    if ( $count_val !== null && $count_val !== 0 && $count_val !== '0' ) : ?>
                                                                        <div class="flex items-center">
                                                                            <?php
                                                                            if ( strpos( $count_val, '<' ) !== false ) {
                                                                                echo $count_val;
                                                                            } else {
                                                                                echo '<span class="text-xs text-gray-500 font-medium">' . esc_html( $count_val ) . '</span>';
                                                                            }
                                                                            ?>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                                <a href="<?php echo esc_url( $panel['url'] ); ?>" class="text-gray-300 group-hover:text-indigo-500 transition-colors">
                                                                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                                                    </svg>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php else : ?>
                                                    <div class="panel-item flex flex-col gap-1 px-4 py-3 hover:bg-gray-50 transition-colors group relative"
                                                         data-panel-name="<?php echo esc_attr( strtolower( $panel['name'] ) ); ?>"
                                                         data-panel-desc="<?php echo esc_attr( strtolower( $panel['description'] ?? '' ) ); ?>"
                                                         data-panel-slug="<?php echo esc_attr( $panel['slug'] ); ?>">
                                                        <div class="flex items-center gap-3">
                                                            <a href="<?php echo esc_url( $panel['url'] ); ?>" class="flex items-center gap-3 flex-1 min-w-0">
                                                                <div class="w-8 h-8 rounded-lg flex items-center justify-center transition-colors slipstream-panel-icon" style="<?php echo $icon_style; ?>">
                                                                    <?php
                                                                    if ( isset( $panel['icon'] ) ) {
                                                                        if ( strpos( $panel['icon'], '<svg' ) !== false ) {
                                                                            echo $panel['icon'];
                                                                        } else {
                                                                            echo '<span class="text-lg">' . $panel['icon'] . '</span>';
                                                                        }
                                                                    } else {
                                                                        echo '<span class="text-lg">📦</span>';
                                                                    }
                                                                    ?>
                                                                </div>
                                                                <div class="font-medium text-gray-900 truncate text-sm"><?php echo esc_html( $panel['name'] ); ?></div>
                                                            </a>
                                                            <div class="flex items-center gap-2">
                                                                <?php
                                                                if ( isset( $panel['count'] ) ) {
                                                                    $count_val = is_callable( $panel['count'] ) ? call_user_func( $panel['count'] ) : $panel['count'];
                                                                    if ( $count_val !== null && $count_val !== 0 && $count_val !== '0' ) {
                                                                        if ( strpos( $count_val, '<' ) !== false ) {
                                                                            echo $count_val;
                                                                        } else {
                                                                            echo '<span class="text-xs text-gray-400">' . esc_html( $count_val ) . '</span>';
                                                                        }
                                                                    }
                                                                }
                                                                ?>
                                                                <a href="<?php echo esc_url( $panel['url'] ); ?>" class="text-gray-300 group-hover:text-indigo-500 transition-colors">
                                                                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                                                    </svg>
                                                                </a>
                                                            </div>
                                                        </div>
                                                        <div class="panel-quick-links" style="display: none;"></div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                <?php endforeach;
                            else : ?>
                                <p class="px-4 py-3 text-sm text-gray-500 italic">No settings panels registered.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Right Column: User Info & Welcome (On mobile this becomes a tab or stacks) -->
                <div class="w-full md:w-2/3 p-0 md:p-6 py-6">
                    <?php
                    $welcome_title = get_option( 'slipstream_welcome_title', 'Welcome back, {{user_name}}!' );
                    $welcome_desc = get_option( 'slipstream_welcome_desc', 'Manage your site settings and content from the {{brand_name}} Dashboard.' );

                    $welcome_title = str_replace(
                            array( '{{user_name}}', '{{brand_name}}' ),
                            array( wp_get_current_user()->display_name, $brand_name ),
                            $welcome_title
                    );
                    $welcome_desc = str_replace(
                            array( '{{user_name}}', '{{brand_name}}' ),
                            array( wp_get_current_user()->display_name, $brand_name ),
                            $welcome_desc
                    );

                    // Get registered welcome tabs
                    $welcome_tabs = Slipstream_Registry::get_instance()->get_data( 'welcome_tabs' );
                    if ( ! empty( $welcome_tabs ) ) {
                        uasort( $welcome_tabs, function( $a, $b ) {
                            return ( $a['priority'] ?? 10 ) - ( $b['priority'] ?? 10 );
                        } );
                    }
                    ?>
                    <!-- Welcome Card -->
                    <div class="rounded-none md:rounded-t-3xl shadow-lg text-white relative overflow-hidden flex flex-col mb-0" style="background-color: var(--ss-brand-color, #4f46e5);">
                        <div class="p-6 md:p-10 relative z-10 flex items-center gap-4 md:gap-8">
                            <?php if ( $brand_logo ) : ?>
                                <img src="<?php echo esc_url( $brand_logo ); ?>" alt="<?php echo esc_attr( $brand_name ); ?>" class="h-12 md:h-20 w-auto object-contain">
                            <?php endif; ?>
                            <div>
                                <h1 class="text-2xl md:text-3xl font-bold mb-1 md:mb-2 text-white"><?php echo esc_html( $welcome_title ); ?></h1>
                                <p class="opacity-80 text-base md:text-lg"><?php echo esc_html( $welcome_desc ); ?></p>
                            </div>
                        </div>

                        <?php if ( ! empty( $welcome_tabs ) ) : ?>
                            <!-- Welcome Card Tabs (iOS Segmented Control + Mobile Dropdown) -->
                            <div class="flex items-center justify-between px-6 md:px-10 pb-0 relative z-20">
                                <div class="relative flex items-center">
                                    <!-- Desktop Segmented Control -->
                                    <div class="hidden md:flex relative gap-1 bg-[#e3e3e8] p-1 rounded-2xl w-fit" role="tablist" aria-label="Welcome Tabs">
                                        <div id="ss-welcome-tab-indicator" class="absolute bg-[var(--ss-brand-color,#4f46e5)] rounded-[14px] shadow-sm h-[calc(100%-8px)] top-1 left-1 z-0 ss-tab-indicator"></div>
                                        <?php 
                                        $first_tab = true;
                                        foreach ( $welcome_tabs as $tab_slug => $tab ) : 
                                            $is_active = $first_tab;
                                            ?>
                                            <button type="button"
                                                onclick="window.ssWelcomeSwitchTab('<?php echo esc_js( $tab_slug ); ?>', this)"
                                                id="ss-welcome-tab-btn-<?php echo esc_attr( $tab_slug ); ?>"
                                                role="tab"
                                                aria-selected="<?php echo $is_active ? 'true' : 'false'; ?>"
                                                aria-controls="welcome-<?php echo esc_attr( $tab_slug ); ?>-content"
                                                class="relative z-10 px-6 py-2 rounded-xl text-[13px] font-bold tracking-tight transition-colors whitespace-nowrap <?php echo $is_active ? 'ss-tab-active' : 'ss-tab-inactive hover:text-slate-800'; ?>">
                                                <?php echo esc_html( $tab['title'] ); ?>
                                            </button>
                                            <?php 
                                            $first_tab = false;
                                        endforeach; 
                                        ?>
                                    </div>

                                    <!-- Mobile Dropdown -->
                                    <div class="md:hidden relative">
                                        <?php 
                                        $first_title = '';
                                        foreach ( $welcome_tabs as $tab_slug => $tab ) { $first_title = $tab['title']; break; }
                                        ?>
                                        <button type="button"
                                            onclick="window.ssWelcomeToggleDropdown()"
                                            id="ss-welcome-mobile-trigger"
                                            class="flex items-center gap-3 bg-[var(--ss-brand-color,#4f46e5)] text-white px-5 py-2.5 rounded-2xl font-bold text-sm shadow-lg shadow-indigo-200 active:scale-95 transition-transform">
                                            <span id="ss-welcome-active-label"><?php echo esc_html( $first_title ); ?></span>
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 opacity-70" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="3">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                                            </svg>
                                        </button>

                                        <div id="ss-welcome-mobile-menu" class="ss-dropdown-menu absolute left-0 top-full mt-2 w-64 bg-white/80 backdrop-blur-xl rounded-2xl shadow-2xl border border-slate-200 z-50 overflow-hidden">
                                            <div class="flex flex-col">
                                                <?php $first_tab = true; foreach ( $welcome_tabs as $tab_slug => $tab ) : ?>
                                                    <button onclick="window.ssWelcomeSwitchTab('<?php echo esc_js( $tab_slug ); ?>', document.getElementById('ss-welcome-tab-btn-<?php echo esc_attr( $tab_slug ); ?>'))" class="w-full px-5 py-3.5 text-sm font-semibold text-slate-700 hover:bg-slate-100/50 text-left <?php echo $first_tab ? 'border-b border-slate-100' : ''; ?> flex items-center justify-between">
                                                        <?php echo esc_html( $tab['title'] ); ?>
                                                        <span id="ss-welcome-check-<?php echo esc_attr( $tab_slug ); ?>" class="text-[var(--ss-brand-color,#4f46e5)] <?php echo $first_tab ? '' : 'hidden'; ?>">
                                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="3"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" /></svg>
                                                        </span>
                                                    </button>
                                                <?php $first_tab = false; endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Decorative elements -->
                        <div class="absolute top-0 right-0 -mr-16 -mt-16 w-64 h-64 bg-white rounded-full opacity-10"></div>
                    </div>

                    <?php if ( ! empty( $welcome_tabs ) ) : ?>
                        <?php 
                        $first_content = true;
                        foreach ( $welcome_tabs as $tab_slug => $tab ) : 
                            $is_visible = $first_content;
                            ?>
                            <!-- <?php echo esc_html( $tab['title'] ); ?> Content -->
                            <div id="welcome-<?php echo esc_attr( $tab_slug ); ?>-content" 
                                 role="tabpanel"
                                 aria-labelledby="tab-<?php echo esc_attr( $tab_slug ); ?>"
                                 class="ss-welcome-content bg-white rounded-none md:rounded-b-3xl shadow-sm border-x md:border border-slate-100 p-6 md:p-8 mb-8" 
                                 style="<?php echo $is_visible ? '' : 'display: none;'; ?>">
                                <?php 
                                if ( isset( $tab['content'] ) ) {
                                    if ( is_callable( $tab['content'] ) ) {
                                        echo call_user_func( $tab['content'] );
                                    } else {
                                        echo $tab['content'];
                                    }
                                }
                                ?>
                            </div>
                            <?php 
                            $first_content = false;
                        endforeach; 
                        ?>
                    <?php endif; ?>

                    <script>
                        (function() {
                            function byId(id){ return document.getElementById(id); }
                            function qsa(sel,scope){ return Array.prototype.slice.call((scope||document).querySelectorAll(sel)); }

                            window.ssWelcomeSwitchTab = function(tabId, el){
                                const indicator = byId('ss-welcome-tab-indicator');
                                const mobileMenu = byId('ss-welcome-mobile-menu');
                                const activeLabel = byId('ss-welcome-active-label');
                                const buttons = qsa('[id^="ss-welcome-tab-btn-"]');

                                // Labels map from button textContent
                                const activeBtn = byId('ss-welcome-tab-btn-' + tabId);
                                if (activeBtn) {
                                    activeLabel && (activeLabel.textContent = activeBtn.textContent.trim());
                                }

                                // Show checkmark
                                qsa('[id^="ss-welcome-check-"]').forEach(n=>n.classList.add('hidden'));
                                const ck = byId('ss-welcome-check-' + tabId); if (ck) ck.classList.remove('hidden');

                                // Hide mobile menu
                                if (mobileMenu) mobileMenu.classList.remove('show');

                                // Move indicator for desktop
                                if (indicator && el && el.offsetParent !== null) {
                                    indicator.style.width = el.offsetWidth + 'px';
                                    indicator.style.left = el.offsetLeft + 'px';
                                }

                                // Active/inactive styles + aria
                                buttons.forEach(btn => {
                                    const isActive = btn.id === 'ss-welcome-tab-btn-' + tabId;
                                    btn.setAttribute('aria-selected', isActive ? 'true' : 'false');
                                    btn.classList.toggle('ss-tab-active', isActive);
                                    btn.classList.toggle('ss-tab-inactive', !isActive);
                                });

                                // Switch content
                                qsa('.ss-welcome-content').forEach(c => c.style.display = 'none');
                                const activeContent = byId('welcome-' + tabId + '-content');
                                if (activeContent) activeContent.style.display = '';

                                // Scroll into view on mobile
                                if (window.innerWidth < 768 && activeContent) {
                                    const top = activeContent.getBoundingClientRect().top + window.scrollY - 100;
                                    window.scrollTo({ top, behavior: 'smooth' });
                                }
                            };

                            window.ssWelcomeToggleDropdown = function(){
                                const menu = byId('ss-welcome-mobile-menu');
                                if (menu) menu.classList.toggle('show');
                            };

                            // Close dropdown on outside click and ESC
                            window.addEventListener('click', function(e){
                                if (!e.target.closest('#ss-welcome-mobile-trigger') && !e.target.closest('#ss-welcome-mobile-menu')) {
                                    const menu = byId('ss-welcome-mobile-menu');
                                    if (menu) menu.classList.remove('show');
                                }
                            });
                            window.addEventListener('keydown', function(e){
                                if (e.key === 'Escape') {
                                    const menu = byId('ss-welcome-mobile-menu');
                                    if (menu) menu.classList.remove('show');
                                }
                            });

                            // Initialize indicator position to first visible desktop tab
                            window.addEventListener('load', function(){
                                const first = document.querySelector('[id^="ss-welcome-tab-btn-"]');
                                if (first) {
                                    // ensure indicator width/left match first tab
                                    const ind = byId('ss-welcome-tab-indicator');
                                    if (ind) {
                                        ind.style.width = first.offsetWidth + 'px';
                                        ind.style.left = first.offsetLeft + 'px';
                                    }
                                }
                            });
                        })();
                    </script>

                    <!-- Widgets Section -->
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 md:gap-6 px-4 md:px-0">
                        <?php
                        $widget_handler = Slipstream_Widgets::get_instance();
                        $widgets = $widget_handler->get_widgets();

                        if ( ! empty( $widgets ) ) :
                            foreach ( $widgets as $slug => $widget ) :
                                $width_class = ( isset( $widget['width'] ) && $widget['width'] === 'half' ) ? 'col-span-1' : 'col-span-1 sm:col-span-2';
                                ?>
                                <div class="bg-white rounded-2xl md:rounded-3xl shadow-sm p-5 md:p-6 <?php echo $width_class; ?>">
                                    <h3 class="text-lg font-bold text-gray-900 mb-4"><?php echo esc_html( $widget['title'] ); ?></h3>
                                    <div class="widget-content">
                                        <?php echo $widget_handler->render_widget_content( $widget ); ?>
                                    </div>
                                </div>
                            <?php
                            endforeach;
                        endif;
                        ?>
                    </div>
                </div>
            </div>
        <?php else : ?>
            <!-- Page Header for non-dashboard pages -->
            <div id="slipstream-page-header" class="flex-1 flex flex-col">
                <div class="sticky top-0  z-[9999] w-full pointer-events-none py-5 px-8">
                    <div class="flex items-center gap-2">
                        <a href="<?php echo admin_url(); ?>" class="pointer-events-auto group flex items-center justify-center w-10 h-10 rounded-full bg-white/20 backdrop-blur-md border border-white/30 shadow-lg hover:bg-white/40 transition-all" title="Back to Dashboard">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                            </svg>
                        </a>
                        
                        <?php
                        // Check if we should show an automated save button
                        $current_page = basename( $_SERVER['PHP_SELF'] );
                        $current_plugin_page = isset( $_GET['page'] ) ? $_GET['page'] : '';
                        $show_save = false;
                        $save_label = 'Save Changes';
                        $target_form = 'form'; // Default selector

                        // Auto-detect for post editing
                        if ( in_array( $current_page, array( 'post.php', 'post-new.php' ) ) ) {
                            $show_save = true;
                            $save_label = 'Update Content';
                            $target_form = '#post';
                        }

                        // Check registry for explicit save mapping
                        $registry = Slipstream_Registry::get_instance();
                        $panels = $registry->get_data( 'panels' );
                        foreach ( $panels as $slug => $panel ) {
                            if ( isset( $panel['url'] ) && strpos( $panel['url'], $current_plugin_page ) !== false && ! empty( $panel['save_mapping'] ) ) {
                                $show_save = true;
                                if ( is_array( $panel['save_mapping'] ) ) {
                                    $save_label = $panel['save_mapping']['label'] ?? $save_label;
                                    $target_form = $panel['save_mapping']['form'] ?? $target_form;
                                }
                                break;
                            }
                        }

                        if ( $show_save ) :
                        ?>
                        <button type="button" id="slipstream-auto-save" data-target="<?php echo esc_attr($target_form); ?>" class="pointer-events-auto flex items-center gap-2 h-10 px-6 rounded-full bg-indigo-600 backdrop-blur-md border border-indigo-400 shadow-lg hover:bg-indigo-700 transition-all text-white text-sm font-bold">
                            <?php echo esc_html( $save_label ); ?>
                        </button>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="px-4 md:px-6">
                    <!-- This is where standard WP admin content will be injected -->
                    <div id="slipstream-content" class="bg-white rounded-2xl md:rounded-3xl shadow-sm p-4 md:p-6 overflow-hidden flex-1 mb-8">
                        <?php
                        if ( ! empty( $wp_content ) ) {
                            echo $wp_content;
                        }
                        ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <script>
            (function() {
                const sidebarSearch = document.getElementById('slipstream-sidebar-search');
                const panelItems = document.querySelectorAll('.panel-item');
                const groupSections = document.querySelectorAll('.group-section');

                // Toggle Button AJAX Handler
                document.querySelectorAll('.slipstream-toggle-btn').forEach(btn => {
                    btn.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();

                        const slug = this.getAttribute('data-slug');
                        const action = this.getAttribute('data-action');
                        const nonce = this.getAttribute('data-nonce');
                        const isChecked = this.getAttribute('aria-checked') === 'true';
                        const newState = !isChecked;

                        // Optimistic UI update
                        this.setAttribute('aria-checked', newState.toString());
                        const dot = this.querySelector('span');
                        if (newState) {
                            this.classList.remove('bg-gray-200');
                            this.classList.add('bg-indigo-600');
                            dot.classList.remove('translate-x-0');
                            dot.classList.add('translate-x-5');
                        } else {
                            this.classList.remove('bg-indigo-600');
                            this.classList.add('bg-gray-200');
                            dot.classList.remove('translate-x-5');
                            dot.classList.add('translate-x-0');
                        }

                        // AJAX Call
                        const formData = new FormData();
                        formData.append('action', 'slipstream_panel_toggle');
                        formData.append('panel_slug', slug);
                        formData.append('toggle_action', action);
                        formData.append('state', newState ? 'on' : 'off');
                        formData.append('_ajax_nonce', nonce);

                        fetch(ajaxurl, {
                            method: 'POST',
                            body: formData
                        })
                            .then(response => response.json())
                            .then(data => {
                                if (!data.success) {
                                    // Revert UI on failure
                                    alert(data.data || 'Failed to update setting.');
                                    this.setAttribute('aria-checked', isChecked.toString());
                                    if (isChecked) {
                                        this.classList.add('bg-indigo-600');
                                        this.classList.remove('bg-gray-200');
                                        dot.classList.add('translate-x-5');
                                        dot.classList.remove('translate-x-0');
                                    } else {
                                        this.classList.add('bg-gray-200');
                                        this.classList.remove('bg-indigo-600');
                                        dot.classList.add('translate-x-0');
                                        dot.classList.remove('translate-x-5');
                                    }
                                }
                            })
                            .catch(err => {
                                console.error('Toggle error:', err);
                                // Revert on error
                            });
                    });
                });

                // Auto-Save Button Handler
                const autoSaveBtn = document.getElementById('slipstream-auto-save');
                if (autoSaveBtn) {
                    autoSaveBtn.addEventListener('click', function() {
                        const targetSelector = this.getAttribute('data-target');
                        const form = document.querySelector(targetSelector);
                        if (form) {
                            // Look for a submit button in the form and click it, or just submit the form
                            const submitBtn = form.querySelector('button[type="submit"], input[type="submit"]');
                            if (submitBtn) {
                                submitBtn.click();
                            } else {
                                form.submit();
                            }
                    
                            // Visual feedback
                            this.classList.add('opacity-50', 'cursor-wait');
                            this.innerHTML = `
                                <svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                  <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                  <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                Saving...
                            `;
                        }
                    });
                }

                // Debounce function to prevent too many AJAX calls
                function debounce(func, wait) {
                    let timeout;
                    return function executedFunction(...args) {
                        const later = () => {
                            clearTimeout(timeout);
                            func(...args);
                        };
                        clearTimeout(timeout);
                        timeout = setTimeout(later, wait);
                    };
                }

                if (sidebarSearch) {
                    const handleSearch = debounce(function(e) {
                        const term = e.target.value.toLowerCase().trim();

                        if (term === '') {
                            // Reset everything
                            groupSections.forEach(section => {
                                section.style.display = 'block';
                                section.querySelectorAll('.panel-item').forEach(item => {
                                    item.style.display = 'flex';
                                    const ql = item.querySelector('.panel-quick-links');
                                    if (ql) {
                                        ql.innerHTML = '';
                                        ql.style.display = 'none';
                                    }
                                });
                            });
                            return;
                        }

                        // Local Filter first
                        groupSections.forEach(section => {
                            let hasVisiblePanel = false;
                            const items = section.querySelectorAll('.panel-item');
                            const groupName = section.getAttribute('data-group-name');

                            items.forEach(item => {
                                const name = item.getAttribute('data-panel-name');
                                const desc = item.getAttribute('data-panel-desc');
                                const ql = item.querySelector('.panel-quick-links');

                                // Intelligent match: panel name, description, or even group name
                                const nameMatch = name ? name.includes(term) : false;
                                const descMatch = desc ? desc.includes(term) : false;
                                const groupMatch = groupName ? groupName.includes(term) : false;

                                if (nameMatch || descMatch || groupMatch) {
                                    item.style.display = 'flex';
                                    hasVisiblePanel = true;
                                } else {
                                    item.style.display = 'none';
                                }

                                // Clear quick links during new search
                                if (ql) {
                                    ql.innerHTML = '';
                                    ql.style.display = 'none';
                                }
                            });

                            // Hide section if no panels match initially
                            section.style.display = hasVisiblePanel ? 'block' : 'none';
                        });

                        // Deep Search via AJAX for post types
                        fetch(ajaxurl + '?action=slipstream_search&term=' + encodeURIComponent(term) + '&_ajax_nonce=<?php echo wp_create_nonce("slipstream_search"); ?>')
                            .then(response => response.json())
                            .then(data => {
                                if (data.success && data.data.results) {
                                    // Track added IDs to prevent duplicates in current result set
                                    const addedResultIds = new Set();

                                    data.data.results.forEach(result => {
                                        if (result.type === 'post') {
                                            // Find the panel for this post type
                                            const panel = document.querySelector(`.panel-item[data-panel-slug="${result.panel_slug}"]`);
                                            if (panel) {
                                                panel.style.display = 'flex';
                                                // Ensure the group is visible
                                                const section = panel.closest('.group-section');
                                                if (section) section.style.display = 'block';

                                                const ql = panel.querySelector('.panel-quick-links');
                                                if (ql) {
                                                    ql.style.display = 'flex';

                                                    // Create unique ID for the link to avoid duplicates
                                                    const linkId = `ql-${result.type}-${result.id || Math.random().toString(36).substr(2, 9)}`;
                                                    if (addedResultIds.has(linkId)) return;
                                                    addedResultIds.add(linkId);

                                                    const link = document.createElement('a');
                                                    link.href = result.url;
                                                    link.className = 'quick-link-item';
                                                    link.style.color = 'var(--ss-brand-color, #6366f1)';
                                                    link.style.backgroundColor = 'rgba(var(--ss-brand-color-rgb, 99, 102, 241), 0.1)';
                                                    link.textContent = result.title;
                                                    link.onclick = (e) => e.stopPropagation();
                                                    ql.appendChild(link);
                                                }
                                            }
                                        }
                                    });
                                }
                            });
                    }, 300);

                    sidebarSearch.addEventListener('input', handleSearch);
                }
            })();
        </script>

        <style>
            .custom-scrollbar::-webkit-scrollbar {
                width: 4px;
            }
            .custom-scrollbar::-webkit-scrollbar-track {
                background: transparent;
            }
            .custom-scrollbar::-webkit-scrollbar-thumb {
                background: #e5e7eb;
                border-radius: 10px;
            }
            .custom-scrollbar::-webkit-scrollbar-thumb:hover {
                background: #d1d5db;
            }
        </style>
